/*
 * Decompiled with CFR 0.152.
 */
package org.jpype;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Predicate;

public class JPypeUtilities {
    private static final Method[] OBJECT_METHODS = (Method[])Arrays.stream(Object.class.getMethods()).filter(method -> !Modifier.isFinal(method.getModifiers())).toArray(Method[]::new);
    private static final Predicate<Class> isSealed;

    public static Path getJarPath(Class clazz) {
        try {
            return Paths.get(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static Method getFunctionalInterfaceMethod(Class clazz) {
        if (!clazz.isInterface() || clazz.isAnnotation() || isSealed.test(clazz)) {
            return null;
        }
        Method method = null;
        for (Method method2 : clazz.getMethods()) {
            if (!Modifier.isAbstract(method2.getModifiers()) || JPypeUtilities.isObjectMethodOverride(method2)) continue;
            if (method != null && !JPypeUtilities.equals(method2, method)) {
                return null;
            }
            if (method != null && !clazz.equals(method2.getDeclaringClass())) continue;
            method = method2;
        }
        return method;
    }

    private static boolean isObjectMethodOverride(Method method) {
        for (Method method2 : OBJECT_METHODS) {
            if (!JPypeUtilities.equals(method, method2)) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(Method method, Method method2) {
        if (method.getParameterCount() != method2.getParameterCount()) {
            return false;
        }
        if (!method.getName().equals(method2.getName())) {
            return false;
        }
        return Arrays.equals(method.getParameterTypes(), method2.getParameterTypes());
    }

    static {
        Predicate predicate = null;
        try {
            Method method2 = Class.class.getMethod("isSealed", new Class[0]);
            MethodHandle methodHandle = MethodHandles.publicLookup().unreflect(method2);
            predicate = MethodHandleProxies.asInterfaceInstance(Predicate.class, methodHandle);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            predicate = clazz -> false;
        }
        isSealed = predicate;
    }
}

