/*
 * Decompiled with CFR 0.152.
 */
package org.jpype;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JPypeClassLoader
extends URLClassLoader {
    HashMap<String, ArrayList<URL>> map = new HashMap();
    int code = 0;

    public JPypeClassLoader(ClassLoader classLoader) {
        super(JPypeClassLoader.initial(), classLoader);
    }

    public int getCode() {
        return this.code;
    }

    private static URL[] initial() {
        String string = System.getProperty("jpype.class.path");
        if (string == null) {
            return new URL[0];
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            String string2;
            n2 = string.indexOf(File.pathSeparator, n);
            String string3 = string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
            if (!string2.isEmpty()) {
                try {
                    URL uRL = Paths.get(string2, new String[0]).toUri().toURL();
                    if (uRL != null) {
                        arrayList.add(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Malformed url in classpath skipped " + string2);
                }
            }
            n = n2 + 1;
        }
        System.clearProperty("jpype.class.path");
        System.setProperty("java.class.path", string);
        return arrayList.toArray(new URL[0]);
    }

    private void appendToClassPathForInstrumentation(String string) throws Throwable {
        this.addURL(Paths.get(string, new String[0]).toAbsolutePath().toUri().toURL());
    }

    public void addPaths(final Path path, String string) throws IOException {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(string);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                if (pathMatcher.matches(path.relativize(path2))) {
                    URL uRL = path2.toUri().toURL();
                    JPypeClassLoader.this.addURL(uRL);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path2, IOException iOException) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void addPath(Path path) throws FileNotFoundException {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(path.toString());
            }
            this.addURL(path.toUri().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public Class findClass(String string) throws ClassNotFoundException, ClassFormatError {
        Class<?> clazz;
        block10: {
            String string2 = string.replace('.', '/') + ".class";
            URL uRL = this.getResource(string2);
            if (uRL == null) {
                throw new ClassNotFoundException(string);
            }
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                clazz = this.defineClass(null, byArray2, 0, byArray2.length);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException(string);
                }
            }
            inputStream.close();
        }
        return clazz;
    }

    @Override
    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (uRL != null) {
            return uRL;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.map.containsKey(string)) {
            return this.map.get(string).get(0);
        }
        if (string.startsWith("org/jpype/")) {
            return this.getResource("META-INF/versions/0/" + string);
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.addAll(Collections.list(super.findResources(string)));
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.map.containsKey(string)) {
            arrayList.addAll((Collection)this.map.get(string));
        }
        return Collections.enumeration(arrayList);
    }

    public void addResource(String string, URL uRL) {
        if (!this.map.containsKey(string)) {
            this.map.put(string, new ArrayList());
        }
        this.map.get(string).add(uRL);
    }

    @Override
    public void addURL(URL uRL) {
        Path path;
        this.code = this.code * 98745623 + uRL.hashCode();
        super.addURL(uRL);
        try {
            path = Paths.get(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return;
        }
        this.scanJar(path);
    }

    void scanJar(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            URI uRI = path.toAbsolutePath().toUri();
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (string.startsWith("META-INF/")) continue;
                if (jarEntry.isDirectory()) {
                    return;
                }
                int n = 0;
                while ((n = string.indexOf("/", n)) != -1) {
                    String string2 = string.substring(0, n);
                    ++n;
                    if (hashSet.contains(string2)) continue;
                    String string3 = "jar:" + uRI + "!/" + string2 + "/";
                    hashSet.add(string2);
                    this.addResource(string2, new URL(string3));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

